#include <iostream>
#include <string>
#include <cstdio>
#include <iomanip>
#include <cmath>
#include <vector>
#include <map>
#include <set>
#include <algorithm>
#include <cstdlib>
#include <cstring>

using namespace std;

const int MAX_N = 2005;
const int MOD = 1000000007;

int n, x, C[MAX_N][MAX_N];
long long d;
int dp[MAX_N][MAX_N];

int powMod(int n, int k) {
    if (k == 0) {
        return 1;
    }

    int x = powMod(n, k / 2);

    x = ((long long)x * x) % MOD;

    if (k & 1) {
        x = ((long long)x * n) % MOD;
    }

    return x;
}

int binomial(long long n, int k) {
    int ans = 1;

    for (long long i = n; i > n - k; i--) {
        ans = ((long long)ans * (i % MOD)) % MOD;
    }

    for (int i = 1; i <= k; i++) {
        ans = ((long long)ans * powMod(i, MOD - 2)) % MOD;
    }

    return ans;
}

int main() {
    ios_base::sync_with_stdio(false);
    //freopen(".in", "r", stdin);
    //freopen(".out", "w", stdout);

    C[0][0] = 1;
    for (int i = 1; i < MAX_N; i++) {
        C[i][0] = 1;
        for (int j = 1; j < MAX_N; j++) {
            C[i][j] = (C[i - 1][j] + C[i - 1][j - 1]) % MOD;
        }
    }

    while (cin >> n >> d >> x) {
        if (n == 0 && x == 0 && d == 0) {
            break;
        }

        memset(dp, 0, sizeof(dp));

        dp[0][0] = 1;

        int ans = 0;

        for (int fullDays = 1; fullDays <= min((long long)n, d); fullDays++) {
            long long sum[MAX_N] = {dp[fullDays - 1][0]};

            for (int i = 1; i <= n; i++) {
                sum[i] = sum[i - 1] + dp[fullDays - 1][i];

                long long cur_dp = sum[i - 1];

                if (i - x >= 0) {
                    cur_dp -= sum[i - x];
                }

                dp[fullDays][i] = cur_dp % MOD;
            }

            int cur_ans = ((long long)binomial(d, fullDays) * dp[fullDays][n]) % MOD;
            ans = (ans + cur_ans) % MOD;
        }

        cout << ans << endl;
    }

    return 0;
}
